
#ifndef _1_KMNG_SEP_ATP_Defines_h_H
#define _1_KMNG_SEP_ATP_Defines_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */


#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon March 22 07:21:17 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file contains defines, required for KMNG ATP tests
   *
   *  \version KMNG_SEP_ATP_Defines.h#1:incl:1
   *  \author Annag
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */


/************************ Global Data **************************/

#define   KMNG_TEST_PASS  0
#define   KMNG_TEST_FAIL  1
/************************ Defines ******************************/
/* Defines for Enabling DH */
/*-------------------------*/
#define TST_DH_NOT_SUPPORTED

/* Defines for Enable log printouts */
/*----------------------------------*/
#define KMNG_TST_LOG_ENABLE   0

/* Arrays size Defines */
/*---------------------*/
#ifndef TST_FUNC_STRING_LEN
  #define TST_FUNC_STRING_LEN 100
#endif 
#ifndef TST_NAME_STRING_LEN
  #define TST_NAME_STRING_LEN 150
#endif 
#define KMNG_TST_MAX_SIZE_KEY_RING_BUF        17000
#define KMNG_TST_MAX_SIZE_KEY_RING_BUF_BYTES  72000
#define TST_KMNG_PWD_MAX_LEN                  40
#define TST_KMNG_SYM_KEY_MAX_SIZE             64
#define TST_KMNG_MAX_RSA_PARAM_SIZE           256
#define TST_KMNG_MAX_DH_PARAM_SIZE            256

/* General Defines */
/*-----------------*/

#define TST_KMNG_MAX_SIZE_DATA          256
#define TST_KMNG_VERIFY_OUTPUT          1
#define TST_KMNG_DO_NOT_VERIFY_OUTPUT   0

#define TST_KMNG_MD5_OUTPUT_SIZE        16
#define TST_KMNG_SHA1_OUTPUT_SIZE       20
#define TST_KMNG_SHA224_OUTPUT_SIZE     28
#define TST_KMNG_SHA256_OUTPUT_SIZE     32
#define TST_KMNG_SHA384_OUTPUT_SIZE     48
#define TST_KMNG_SHA512_OUTPUT_SIZE     64

#define TST_KMNG_AES_128_KEYSIZE        16
#define TST_KMNG_AES_192_KEYSIZE        24
#define TST_KMNG_AES_256_KEYSIZE        32
#define TST_KMNG_HMAC_160_KEYSIZE       20
#define TST_KMNG_HMAC_224_KEYSIZE       28
#define TST_KMNG_HMAC_256_KEYSIZE       32
#define TST_KMNG_HMAC_384_KEYSIZE       48
#define TST_KMNG_HMAC_512_KEYSIZE       64
#define TST_KMNG_DES_64_KEYSIZE         8
#define TST_KMNG_DES_128_KEYSIZE        16
#define TST_KMNG_DES_192_KEYSIZE        24

#define TST_KMNG_RSA_1024_KEYSIZE       128
#define TST_KMNG_RSA_2048_KEYSIZE       256
#define TST_KMNG_BITS_IN_BYTE           8
#define TST_KMNG_MAC_SIZE_BYTE          16

/* for V15 DataInSize shoudl be <= (modulus_size - 11) */
#define TST_KMNG_LESS_DATA_FOR_PKCS1V15_ENCRYPT	    11 
/* for V21 DataInSize should be <= (modulus_size - 2*Hash_output_length - 2).*/
#define TST_KMNG_LESS_DATA_FOR_OAEP_ENCRYPT_SHA1	42
#define TST_KMNG_LESS_DATA_FOR_OAEP_ENCRYPT_SHA224	58
#define TST_KMNG_LESS_DATA_FOR_OAEP_ENCRYPT_SHA256	66
#define TST_KMNG_LESS_DATA_FOR_OAEP_ENCRYPT_SHA384	98
#define TST_KMNG_LESS_DATA_FOR_OAEP_ENCRYPT_SHA512	130



/* Defines for Printing level */
/*----------------------------*/
#ifndef ATP_LOG_TST_MAX_LEVEL_ENABLED
  #define ATP_LOG_TST_MAX_LEVEL_ENABLED 20
#endif  
/* Print levels */
/*--------------*/
#define KMNG_ATP_TST_MSG 		  10
#define KMNG_ATP_TST_DBG_HIGH 	  20
#define KMNG_ATP_TST_DBG_MED	  30
#define KMNG_ATP_TST_DBG_LOW 	  40


#ifdef __cplusplus
}
#endif
 
#endif
